#!/bin/bash

# Stok Takip Uygulamasi - Linux/Mac Çalıştırma Dosyası

clear

echo ""
echo "================================"
echo "  📦 STOK TAKİP UYGULAMASI"
echo "================================"
echo ""

# Renk kodları
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Python kontrol fonksiyonu
check_python() {
    if command -v python3 &> /dev/null; then
        PYTHON_CMD="python3"
        echo -e "${GREEN}✅ Python3 bulundu:${NC}"
        python3 --version
        return 0
    elif command -v python &> /dev/null; then
        # Python versiyonunu kontrol et
        PYTHON_VERSION=$(python -c 'import sys; print(".".join(map(str, sys.version_info[:2])))')
        if python -c 'import sys; exit(0 if sys.version_info >= (3, 7) else 1)' 2>/dev/null; then
            PYTHON_CMD="python"
            echo -e "${GREEN}✅ Python bulundu:${NC}"
            python --version
            return 0
        else
            echo -e "${RED}❌ HATA: Python versiyonu çok eski! (${PYTHON_VERSION})${NC}"
            return 1
        fi
    else
        echo -e "${RED}❌ HATA: Python bulunamadı!${NC}"
        return 1
    fi
}

# Tkinter kontrol fonksiyonu
check_tkinter() {
    echo ""
    echo -e "${BLUE}🔍 GUI kütüphanesi kontrol ediliyor...${NC}"
    
    if $PYTHON_CMD -c "import tkinter; print('✅ Tkinter mevcut')" 2>/dev/null; then
        return 0
    else
        echo -e "${RED}❌ HATA: Tkinter bulunamadı!${NC}"
        echo ""
        echo "Tkinter kurulumu için:"
        echo "Ubuntu/Debian: sudo apt-get install python3-tk"
        echo "CentOS/RHEL:   sudo yum install tkinter"
        echo "Fedora:        sudo dnf install python3-tkinter"
        echo "macOS:         brew install python-tk"
        return 1
    fi
}

# Ana dizin kontrol
if [ ! -f "main.py" ]; then
    echo -e "${RED}❌ HATA: main.py dosyası bulunamadı!${NC}"
    echo ""
    echo "Bu dosyayı uygulama klasöründe çalıştırın."
    exit 1
fi

# Python kontrolü
if ! check_python; then
    echo ""
    echo "Python 3.7+ kurulu olmalıdır."
    echo "İndirmek için: https://python.org"
    echo ""
    read -p "Devam etmek için Enter'a basın..."
    exit 1
fi

# Tkinter kontrolü
if ! check_tkinter; then
    echo ""
    read -p "Devam etmek için Enter'a basın..."
    exit 1
fi

# Data klasörünü oluştur
if [ ! -d "data" ]; then
    echo ""
    echo -e "${YELLOW}📁 Data klasörü oluşturuluyor...${NC}"
    mkdir -p data
fi

# Gerekli dosyaları kontrol et
missing_files=()

if [ ! -f "stok_manager.py" ]; then
    missing_files+=("stok_manager.py")
fi

if [ ! -d "gui" ]; then
    missing_files+=("gui/ klasörü")
fi

if [ ${#missing_files[@]} -gt 0 ]; then
    echo -e "${RED}❌ HATA: Eksik dosyalar:${NC}"
    for file in "${missing_files[@]}"; do
        echo "  - $file"
    done
    echo ""
    echo "Tüm uygulama dosyalarının mevcut olduğundan emin olun."
    exit 1
fi

echo ""
echo -e "${GREEN}🚀 Uygulama başlatılıyor...${NC}"
echo ""
echo "Kapatmak için pencereyi kapatın veya Ctrl+C yapın."
echo ""

# Ana uygulamayı çalıştır
$PYTHON_CMD main.py

# Çıkış kodu kontrol
exit_code=$?

echo ""
if [ $exit_code -eq 0 ]; then
    echo -e "${GREEN}✅ Uygulama normal şekilde kapandı.${NC}"
else
    echo -e "${RED}❌ Uygulama hata ile sonlandı! (Kod: $exit_code)${NC}"
    echo ""
    echo "Olası çözümler:"
    echo "- Gerekli dosyaların eksik olup olmadığını kontrol edin"
    echo "- Python izinlerini kontrol edin"
    echo "- Hata mesajlarını okuyun"
    echo ""
    echo "Hata ayıklama için manuel başlatma:"
    echo "$PYTHON_CMD main.py"
    echo ""
fi

echo ""
read -p "Devam etmek için Enter'a basın..."
