#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Stok Takip Uygulaması - Ana Dosya
Tüm HTML özelliklerini içeren Python versiyonu
"""

import tkinter as tk
from tkinter import ttk, messagebox
import os
import sys

# Modülleri import et
from gui.main_window import MainWindow
from stok_manager import StokManager

class StokTakipApp:
    def __init__(self):
        """Ana uygulama sınıfı"""
        # Veri dizinini oluştur
        self.data_dir = os.path.join(os.path.dirname(__file__), 'data')
        if not os.path.exists(self.data_dir):
            os.makedirs(self.data_dir)
        
        # Stok yöneticisini başlat
        data_file = os.path.join(self.data_dir, 'stok_data.json')
        self.stok_manager = StokManager(data_file)
        
        # Ana pencereyi oluştur
        self.root = tk.Tk()
        self.root.title("📦 Stok Takip Uygulaması")
        self.root.geometry("1200x800")
        
        # İcon ayarla (varsa)
        try:
            self.root.iconbitmap(default='icon.ico')
        except:
            pass
        
        # Ana pencereyi başlat
        self.main_window = MainWindow(self.root, self.stok_manager)
        
        # Pencere kapatma eventi
        self.root.protocol("WM_DELETE_WINDOW", self.on_closing)
    
    def on_closing(self):
        """Uygulama kapatılırken veriyi kaydet"""
        try:
            self.stok_manager.save_data()
            self.root.destroy()
        except Exception as e:
            messagebox.showerror("Hata", f"Veri kaydedilirken hata oluştu: {e}")
            self.root.destroy()
    
    def run(self):
        """Uygulamayı çalıştır"""
        try:
            self.root.mainloop()
        except KeyboardInterrupt:
            self.on_closing()

def main():
    """Ana fonksiyon"""
    try:
        app = StokTakipApp()
        app.run()
    except Exception as e:
        messagebox.showerror("Kritik Hata", f"Uygulama başlatılırken hata oluştu:\n{e}")
        sys.exit(1)

if __name__ == "__main__":
    main()
